function OrganizedData_Names = SubpopulationsOfPatients_WithNames(ALLData)

Name_Edit = ALLData.Sample_ID;
Surv_Edit = ALLData.Surv_time;
Status_Edit = ALLData.Surv_status;
Tissue_to_Subpopulation = ALLData.Var2;
n_subpop = unique(Tissue_to_Subpopulation);

L = length(unique(Name_Edit));
CompactSubpop = zeros(L,n_subpop);

LIST_IDs = [];
clear counter
counter = 1;

for i=1:length(Name_Edit)

% Check = strfind(Name_Edit, Name_Edit{i});
% IND = find(~cellfun(@isempty,Check));

IND = find(Name_Edit == Name_Edit(i));
TF = any(ismember(IND,LIST_IDs));
if ( TF == 0)
LIST_IDs = [LIST_IDs; IND];
censorship(counter) = unique(Status_Edit(IND));
survivor(counter) = unique(Surv_Edit(IND));
Name_Patient(counter) = unique(Name_Edit(IND));
CompactSubpop(counter,Tissue_to_Subpopulation(IND)) = Tissue_to_Subpopulation(IND);
else
continue
end

counter = counter + 1;
end

for i=1:length(n_subpop)
    SubPop_Names{i} = strcat('Subpop_',num2str(i));
end

Name_Patient = [Name_Patient'];
% OrganizedData_Names = [CompactSubpop,survivor',censorship'];
Surv = [survivor'];
Status = [censorship'];
OrganizedData_Names = dataset(Name_Patient,Surv,Status,{CompactSubpop, SubPop_Names{:}});